import os

from .utils import DatasetBase
from .oxford_pets import OxfordPets


template = ['a photo of a {} texture.']
# template = ['a bad photo of a {} texture.',
#     'a photo of many {} texture.',
#     'a sculpture of a {} texture.',
#     'a photo of the hard to see {} texture.',
#     'a low resolution photo of the {} texture.',
#     'a rendering of a {} texture.',
#     'graffiti of a {} texture.',
#     'a bad photo of the {} texture.',
#     'a cropped photo of the {} texture.',
#     'a tattoo of a {} texture.',
#     'the embroidered {} texture.',
#     'a photo of a hard to see {} texture.',
#     'a bright photo of a {} texture.',
#     'a photo of a clean {} texture.',
#     'a photo of a dirty {} texture.',
#     'a dark photo of the {} texture.',
#     'a drawing of a {} texture.',
#     'a photo of my {} texture.',
#     'the plastic {} texture.',
#     'a photo of the cool {} texture.',
#     'a close-up photo of a {} texture.',
#     'a black and white photo of the {} texture.',
#     'a painting of the {} texture.',
#     'a painting of a {} texture.',
#     'a pixelated photo of the {} texture.',
#     'a sculpture of the {} texture.',
#     'a bright photo of the {} texture.',
#     'a cropped photo of a {} texture.',
#     'a plastic {} texture.',
#     'a photo of the dirty {} texture.',
#     'a jpeg corrupted photo of a {} texture.',
#     'a blurry photo of the {} texture.',
#     'a photo of the {} texture.',
#     'a good photo of the {} texture.',
#     'a rendering of the {} texture.',
#     'a {} in a video game texture.',
#     'a photo of one {} texture.',
#     'a doodle of a {} texture.',
#     'a close-up photo of the {} texture.',
#     'a photo of a {} texture.',
#     'the origami {} texture.',
#     'the {} in a video game texture.',
#     'a sketch of a {} texture.',
#     'a doodle of the {} texture.',
#     'a origami {} texture.',
#     'a low resolution photo of a {} texture.',
#     'the toy {} texture.',
#     'a rendition of the {} texture.',
#     'a photo of the clean {} texture.',
#     'a photo of a large {} texture.',
#     'a rendition of a {} texture.',
#     'a photo of a nice {} texture.',
#     'a photo of a weird {} texture.',
#     'a blurry photo of a {} texture.',
#     'a cartoon {} texture.',
#     'art of a {} texture.',
#     'a sketch of the {} texture.',
#     'a embroidered {} texture.',
#     'a pixelated photo of a {} texture.',
#     'itap of the {} texture.',
#     'a jpeg corrupted photo of the {} texture.',
#     'a good photo of a {} texture.',
#     'a plushie {} texture.',
#     'a photo of the nice {} texture.',
#     'a photo of the small {} texture.',
#     'a photo of the weird {} texture.',
#     'the cartoon {} texture.',
#     'art of the {} texture.',
#     'a drawing of the {} texture.',
#     'a photo of the large {} texture.',
#     'a black and white photo of a {} texture.',
#     'the plushie {} texture.',
#     'a dark photo of a {} texture.',
#     'itap of a {} texture.',
#     'graffiti of the {} texture.',
#     'a toy {} texture.',
#     'itap of my {} texture.',
#     'a photo of a cool {} texture.',
#     'a photo of a small {} texture.',
#     'a tattoo of the {} texture.']
class DescribableTextures(DatasetBase):

    dataset_dir = 'dtd'

    def __init__(self, root):
        self.dataset_dir = os.path.join(root, self.dataset_dir)
        self.image_dir = os.path.join(self.dataset_dir, 'images')
        self.split_path = os.path.join(self.dataset_dir, 'split_zhou_DescribableTextures.json')

        self.template = template

        test = OxfordPets.read_split(self.split_path, self.image_dir)

        super().__init__(test=test)
